/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import panther.util.general.ErrorUtils;
import panther.util.resource.ConnectionFactory;
import panther.util.resource.ConnectionPoolConfiguration;
import panther.util.resource.ConnectionResource;
import panther.util.resource.Resource;
import panther.util.resource.ResourceFactory;
import panther.util.resource.ResourcePool;
import panther.util.resource.ResourcePoolBasic;
import panther.util.resource.ResourcePoolConfiguration;
import panther.util.unicon.ReflectiveUtils;

public class Resources {
    protected static List connectionPools = new ArrayList();
    private static final Logger logger = Logger.getLogger(Resources.class.getName());

    public static Object dangerousGetUnderlyingResource(Object object) {
        return ((Resource)object).getRawResource();
    }

    public static Connection getConnection(String string, String string2) {
        return (ConnectionResource)Resources.getConnectionPool(string).allocate(string2);
    }

    public static void releaseConnection(String string, Connection connection) {
        if (connection == null) {
            return;
        }
        Resources.getConnectionPool(string).release((ConnectionResource)connection);
    }

    public static synchronized void closeAllConnectionPools() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(connectionPools);
        connectionPools = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                ResourcePool resourcePool = (ResourcePool)arrayList.get(i);
                resourcePool.close();
                continue;
            }
            catch (Throwable throwable) {
                ErrorUtils.checkSwallow(throwable);
            }
        }
    }

    public static synchronized void closeConnectionPool(String string) {
        ResourcePool resourcePool = Resources.findPoolByName(connectionPools, string);
        if (resourcePool != null) {
            connectionPools.remove(resourcePool);
            resourcePool.close();
        }
    }

    public static ResourcePool getConnectionPool(String string) {
        return Resources.getConnectionPool(string, "CPDefault");
    }

    public static ResourcePool getConnectionPool(String string, String string2) {
        ResourcePool resourcePool = Resources.findPoolByName(connectionPools, string);
        if (resourcePool == null) {
            resourcePool = Resources.addConnectionPool(string, string2);
        }
        return resourcePool;
    }

    public static Map getAllocationInfo() {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        for (int i = 0; i < connectionPools.size(); ++i) {
            ResourcePool resourcePool = (ResourcePool)connectionPools.get(i);
            hashMap.put(resourcePool.getName(), resourcePool.getAllocationInfo());
        }
        return hashMap;
    }

    protected static synchronized ResourcePool addConnectionPool(String string, String string2) {
        ResourcePool resourcePool = Resources.findPoolByName(connectionPools, string);
        if (resourcePool != null) {
            return resourcePool;
        }
        ConnectionPoolConfiguration connectionPoolConfiguration = ConnectionPoolConfiguration.get(string);
        return Resources.addConnectionPool(connectionPoolConfiguration, string2);
    }

    protected static ResourcePool addConnectionPool(ConnectionPoolConfiguration connectionPoolConfiguration, String string) {
        if (!connectionPoolConfiguration.isValid()) {
            logger.config("Invalid ConnectionPoolConfiguration:\n" + connectionPoolConfiguration);
            throw new Error("ConnectionPool configuration invalid for " + connectionPoolConfiguration.getName() + " / " + string);
        }
        try {
            Class.forName(connectionPoolConfiguration.getDriver());
        }
        catch (Exception exception) {
            logger.config("Unable to load JDBC driver: " + connectionPoolConfiguration.getDriver());
            throw new Error("ConnectionPool driver invalid for " + connectionPoolConfiguration.getName() + " / " + string);
        }
        logger.config("Creating new ResourcePool with the following characteristics:\n" + connectionPoolConfiguration);
        ConnectionFactory connectionFactory = new ConnectionFactory(connectionPoolConfiguration);
        ResourcePool resourcePool = null;
        String string2 = connectionPoolConfiguration.getResourcePoolClassName();
        if (string2 == null) {
            logger.warning("NOTICE: Unknown Connection Pool type: " + string + "\n\tDefaulting to ResourcePoolBasic\n\n");
            resourcePool = new ResourcePoolBasic(connectionPoolConfiguration, connectionFactory);
        } else {
            try {
                String[] stringArray = new String[]{ResourcePoolConfiguration.class.getName(), ResourceFactory.class.getName()};
                Object[] objectArray = new Object[]{connectionPoolConfiguration, connectionFactory};
                resourcePool = (ResourcePool)ReflectiveUtils.instantiate(string2, stringArray, objectArray);
            }
            catch (Exception exception) {
                logger.severe("ERROR: Instantiation error for " + string + " / " + string2 + ": " + exception + "\n\tDefaulting to ResourcePoolBasic\n\n");
                resourcePool = new ResourcePoolBasic(connectionPoolConfiguration, connectionFactory);
            }
        }
        connectionPools.add(resourcePool);
        return resourcePool;
    }

    protected static ResourcePool findPoolByName(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            ResourcePool resourcePool = (ResourcePool)list.get(i);
            if (!resourcePool.getName().equals(string)) continue;
            return resourcePool;
        }
        return null;
    }

    protected static ResourcePool findPoolByDescriptor(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            ResourcePool resourcePool = (ResourcePool)list.get(i);
            if (!resourcePool.getDescriptor().equals(string)) continue;
            return resourcePool;
        }
        return null;
    }
}

